<?php

$inputRules = [
    "firstname" => ["required" => true, "validate" => ["regex" => REGEX_UNIVERSAL_NAME_NUMBER_EXTRA]],
    "lastname" => ["required" => true, "validate" => ["regex" => REGEX_UNIVERSAL_NAME_NUMBER_EXTRA]],
    "address" => ["required" => true, "validate" => ["regex" => REGEX_UNIVERSAL_NAME_NUMBER_EXTRA]],
    "city" => ["required" => true, "validate" => ["regex" => REGEX_UNIVERSAL_NAME_NUMBER_EXTRA]],
    "zipcode" => ["required" => true, "validate" => ["regex" => REGEX_UNIVERSAL_NAME_NUMBER_EXTRA]],
    "email" => ["required" => true, "validate" => ["custom" => 'validEmail']],
    "phone" => ["required" => true, "validate" => ["regex" => REGEX_PHONE_NUMBER_GENERAL]],
    "terms" => ["required" => true, "validate" => []],
];

if (!empty($__RB_config['lng']) && $__RB_config['lng'] == 'en-us') {
    $__RB_address_states = [
        'name' => 'State/Province/Region',
        'list' => [
            [
                'value' => 'AL',
                'name' => 'Alabama'
            ], [
                'value' => 'AK',
                'name' => 'Alaska'
            ], [
                'value' => 'AA',
                'name' => 'APO - AA'
            ], [
                'value' => 'AE',
                'name' => 'APO - AE'
            ], [
                'value' => 'AP',
                'name' => 'APO - AP'
            ], [
                'value' => 'AZ',
                'name' => 'Arizona'
            ], [
                'value' => 'AR',
                'name' => 'Arkansas'
            ], [
                'value' => 'CA',
                'name' => 'California'
            ], [
                'value' => 'CO',
                'name' => 'Colorado'
            ], [
                'value' => 'CT',
                'name' => 'Connecticut'
            ], [
                'value' => 'DE',
                'name' => 'Delaware'
            ], [
                'value' => 'DC',
                'name' => 'District of Columbia'
            ], [
                'value' => 'FL',
                'name' => 'Florida'
            ], [
                'value' => 'GA',
                'name' => 'Georgia'
            ], [
                'value' => 'HI',
                'name' => 'Hawaii'
            ], [
                'value' => 'ID',
                'name' => 'Idaho'
            ], [
                'value' => 'IL',
                'name' => 'Illinois'
            ], [
                'value' => 'IN',
                'name' => 'Indiana'
            ], [
                'value' => 'IA',
                'name' => 'Iowa'
            ], [
                'value' => 'KS',
                'name' => 'Kansas'
            ], [
                'value' => 'KY',
                'name' => 'Kentucky'
            ], [
                'value' => 'LA',
                'name' => 'Louisiana'
            ], [
                'value' => 'ME',
                'name' => 'Maine'
            ], [
                'value' => 'MD',
                'name' => 'Maryland'
            ], [
                'value' => 'MA',
                'name' => 'Massachusetts'
            ], [
                'value' => 'MI',
                'name' => 'Michigan'
            ], [
                'value' => 'MN',
                'name' => 'Minnesota'
            ], [
                'value' => 'MS',
                'name' => 'Mississippi'
            ], [
                'value' => 'MO',
                'name' => 'Missouri'
            ], [
                'value' => 'MT',
                'name' => 'Montana'
            ], [
                'value' => 'NE',
                'name' => 'Nebraska'
            ], [
                'value' => 'NV',
                'name' => 'Nevada'
            ], [
                'value' => 'NH',
                'name' => 'New Hampshire'
            ], [
                'value' => 'NJ',
                'name' => 'New Jersey'
            ], [
                'value' => 'NM',
                'name' => 'New Mexico'
            ], [
                'value' => 'NY',
                'name' => 'New York'
            ], [
                'value' => 'NC',
                'name' => 'North Carolina'
            ], [
                'value' => 'ND',
                'name' => 'North Dakota'
            ], [
                'value' => 'OH',
                'name' => 'Ohio'
            ], [
                'value' => 'OK',
                'name' => 'Oklahoma'
            ], [
                'value' => 'OR',
                'name' => 'Oregon'
            ], [
                'value' => 'PA',
                'name' => 'Pennsylvania'
            ], [
                'value' => 'RI',
                'name' => 'Rhode Island'
            ], [
                'value' => 'SC',
                'name' => 'South Carolina'
            ], [
                'value' => 'SD',
                'name' => 'South Dakota'
            ], [
                'value' => 'TN',
                'name' => 'Tennessee'
            ], [
                'value' => 'TX',
                'name' => 'Texas'
            ], [
                'value' => 'UT',
                'name' => 'Utah'
            ], [
                'value' => 'VT',
                'name' => 'Vermont'
            ], [
                'value' => 'VA',
                'name' => 'Virginia'
            ], [
                'value' => 'WA',
                'name' => 'Washington'
            ], [
                'value' => 'WV',
                'name' => 'West Virginia'
            ], [
                'value' => 'WI',
                'name' => 'Wisconsin'
            ], [
                'value' => 'WY',
                'name' => 'Wyoming'
            ]
        ]
    ];

    $inputRules['state'] = [
        "required" => true,
        "validate" => ["custom" => 'validState']
    ];
}

if (empty($_POST['firstname']) && isset($_POST['firstName'])) {
    $_POST['firstname'] = $_POST['firstName'];
}

if (empty($_POST['lastname']) && isset($_POST['lastName'])) {
    $_POST['lastname'] = $_POST['lastName'];
}

if (empty($_POST['email']) && isset($_POST['emailAddress'])) {
    $_POST['email'] = $_POST['emailAddress'];
}

if (empty($_POST['phone']) && isset($_POST['phoneNumber'])) {
    $_POST['phone'] = $_POST['phoneNumber'];
}

if (empty($_POST['zipcode']) && isset($_POST['postalCode'])) {
    $_POST['zipcode'] = $_POST['postalCode'];
}

if (empty($_POST['terms']) && isset($_POST['tos'])) {
    $_POST['terms'] = $_POST['tos'];
}

if (!empty($_POST['email'])) {
    $_POST['email'] = preg_replace('/\s/', '', $_POST['email']);
    $_POST['email'] = str_replace(',', '.', $_POST['email']);
    $_POST['email'] = str_replace('..', '.', $_POST['email']);

    $_POST['email'] = explode('@', $_POST['email']);
    $_POST['email'][count($_POST['email']) - 1] = idn_to_ascii($_POST['email'][count($_POST['email']) - 1], IDNA_DEFAULT, INTL_IDNA_VARIANT_UTS46);
    $_POST['email'] = implode('@', $_POST['email']);
}

if (!empty($_POST['phone'])) {
    $_POST['phone'] = preg_replace('/\s/', '', $_POST['phone']);
}

function validEmail($email) {
    if (!preg_match(REGEX_MAIL, $email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        return false;
    }

    $email_host = array_slice(explode("@", $email), -1)[0];

    if (!filter_var($email_host, FILTER_VALIDATE_IP, [ 'flags' => FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE ])) {
        if (!checkdnsrr($email_host . '.', "MX")) {
            return false;
        }
    }

    return true;
}

function validState($state) {
	global $__RB_address_states;

	if (empty($__RB_address_states) || !is_array($__RB_address_states) || empty($__RB_address_states['list']) || !is_array($__RB_address_states['list'])) {
		return true;
	}

	foreach ($__RB_address_states['list'] as $state) {
		if ($state['value'] == $_POST['state']) {
			return true;
		}
	}

	return false;
}

if (__RB_validateInput($inputRules, 'signup')) {
    if (false && $__RB_config['company']['name'] == 'KUTLERA LIMITED') {
        __RB_errorHandler('signup', 'error', 'Currently not possible to sign up');

    } else {
        $product = $_GET['product'] ?? $_GET['p'] ?? $_POST['product'] ?? 0;
        $product = is_numeric($product) && $product > 0 && $product <= 10 ? $product : 0;
        $product = $product > 0 ? '&product='. $product : '';
    
        $_POST['terms'] = 1;
            
        $lng = @$_SESSION['lng'] ?: $__RB_config['lng'] ?: 'eu-en';
    
        $lng = $lng == 'en' ? ($__RB_config['lng'] ?: 'eu-en') : $lng;
    
        echo "<form action=\"". $__RB_config['url']['cp'] . (substr($__RB_config['url']['cp'], -1) == '/' ? '' : '/') ."v2/?lng=". ($lng) . "&v=cloud". $product ."\" method=\"post\" id=\"formSubmit\">";
    
        foreach ($inputRules as $key => $val) {
            echo '<input type="hidden" name="'. $key .'" value="'. $_POST[$key] .'">';
        }
    
        echo "<input type=\"submit\" name=\"post\" style=\"display:none\"></form><script>document.getElementById('formSubmit').submit();</script>";
        exit;
    
        $__RB_success['signup'] = true;
    }
}
