<?php

$inputRules = [
    "email" => ["required" => true, "validate" => ["filter" => FILTER_VALIDATE_EMAIL]],
];

if (__RB_validateInput($inputRules, 'unsubscribe')) {
    $json = "";

    if (__RB_api_cloud(__RB_API_ACTION_CLOUD_CANCEL_SUBSCRIPTION, $_POST, $json)) {
        $__RB_success['unsubscribe'] = true;

    } else {
        if ($json && is_array($json) && !empty($json['code'])) {
            switch($json['code']) {
                case 101:
                    $errorMsg = $__RB_LNG['validation']['mail']['name'] . $__RB_LNG['error']['empty'];

                    break;

                case 102:
                    $errorMsg = $__RB_LNG['validation']['mail']['name'] . $__RB_LNG['error']['validation'];

                    break;

                case 1001:
                case 1004:
                    $errorMsg = $__RB_LNG['error']['form']['unsubscribe']['incorrect'];

                    break;

                case 1002:
                    $errorMsg = $__RB_LNG['error']['form']['unsubscribe']['disabled_user'];

                    break;

                case 1003:
                    $errorMsg = $__RB_LNG['error']['form']['unsubscribe']['cannot'];

                    break;

                default:
                    $errorMsg = "Process error";
            }

            __RB_errorHandler('unsubscribe', $json['code'] <= 1 ? 'process' : 'unsubscribe', $json['code'] <= 1 ? 'Process error' : $errorMsg);

        } else {
            __RB_errorHandler('unsubscribe', 'process', 'Process error');
        }
    }
}

